/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.protostream.builder;

import org.infinispan.api.protostream.builder.IndexedFieldBuilder;
import org.infinispan.api.protostream.builder.MessageBuilder;
import org.infinispan.api.protostream.builder.ProtoBuf;

public class FieldBuilder {
    private final MessageBuilder parent;
    private final String name;
    private final int number;
    private final boolean required;
    private final String type;
    private IndexedFieldBuilder indexing = null;
    private boolean indexEmbedded = false;

    public FieldBuilder(MessageBuilder parent, String name, int number, boolean required, String type) {
        this.parent = parent;
        this.name = name;
        this.number = number;
        this.required = required;
        this.type = type;
    }

    public MessageBuilder message(String name) {
        return this.parent.parent.message(name);
    }

    public FieldBuilder required(String name, int number, String type) {
        return this.parent.required(name, number, type);
    }

    public FieldBuilder optional(String name, int number, String type) {
        return this.parent.optional(name, number, type);
    }

    public IndexedFieldBuilder basic() {
        this.indexing = new IndexedFieldBuilder(this, "@Basic");
        return this.indexing;
    }

    public IndexedFieldBuilder keyword() {
        this.indexing = new IndexedFieldBuilder(this, "@Keyword");
        return this.indexing;
    }

    public IndexedFieldBuilder text() {
        this.indexing = new IndexedFieldBuilder(this, "@Text");
        return this.indexing;
    }

    public FieldBuilder embedded() {
        this.indexEmbedded = true;
        return this;
    }

    public String build() {
        return this.parent.build();
    }

    void write(StringBuilder builder) {
        if (this.indexing != null) {
            this.indexing.write(builder);
        } else if (this.indexEmbedded) {
            ProtoBuf.tab(builder);
            builder.append("/**\n");
            ProtoBuf.tab(builder);
            builder.append(" * @Embedded\n");
            ProtoBuf.tab(builder);
            builder.append(" */\n");
        }
        if (this.required) {
            ProtoBuf.tab(builder);
            builder.append("required ");
        } else {
            ProtoBuf.tab(builder);
            builder.append("optional ");
        }
        builder.append(this.type);
        builder.append(" ");
        builder.append(this.name);
        builder.append(" = ");
        builder.append(this.number);
        builder.append(";");
        ProtoBuf.blankLine(builder);
    }
}

