/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.internal.models.media;

import io.smallrye.openapi.internal.models.media.AbstractSchema;
import io.smallrye.openapi.internal.models.media.SchemaSupport;
import io.smallrye.openapi.model.BaseModel;
import io.smallrye.openapi.model.Extensions;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.media.Schema;

public class Schema
extends AbstractSchema {
    private static final Map<String, BaseModel.MergeDirective> MERGE = Map.of("examples", BaseModel.MergeDirective.OVERRIDE_VALUE);

    protected BaseModel.MergeDirective mergeDirective(String name) {
        return MERGE.getOrDefault(name, BaseModel.MergeDirective.MERGE_VALUES);
    }

    public <T extends BaseModel<org.eclipse.microprofile.openapi.models.media.Schema>> void merge(T other) {
        if (this.isBooleanSchema() || ((org.eclipse.microprofile.openapi.models.media.Schema)other.constructible()).getBooleanSchema() != null) {
            return;
        }
        super.merge(other);
    }

    List<Schema.SchemaType> getTypeList() {
        if (this.isExtension("type")) {
            return null;
        }
        return (List)super.getProperty("type", List.class);
    }

    void setTypeList(List<Schema.SchemaType> types) {
        super.setType(types);
    }

    @Override
    public void setType(List<Schema.SchemaType> types) {
        super.setType(types);
        Extensions.setPrivateExtension((Extensible)this, (String)"nullable", null);
        SchemaSupport.notifyTypeObservers(this, o -> SchemaSupport.setTypesRetainingNull(o, types));
    }

    @Override
    public Schema addType(Schema.SchemaType type) {
        super.addType(type);
        SchemaSupport.notifyTypeObservers(this, o -> o.addType(type));
        return this;
    }

    @Override
    public void removeType(Schema.SchemaType type) {
        super.removeType(type);
        SchemaSupport.notifyTypeObservers(this, o -> o.removeType(type));
    }

    public Boolean getAdditionalPropertiesBoolean() {
        org.eclipse.microprofile.openapi.models.media.Schema schema = this.getAdditionalPropertiesSchema();
        return schema == null ? null : schema.getBooleanSchema();
    }

    public void setAdditionalPropertiesBoolean(Boolean additionalProperties) {
        if (additionalProperties != null) {
            this.setAdditionalPropertiesSchema(new Schema().booleanSchema(additionalProperties));
        } else {
            this.setAdditionalPropertiesSchema(null);
        }
    }

    public Boolean getBooleanSchema() {
        return (Boolean)Extensions.getPrivateExtension((Extensible)this, (String)"boolean-schema", Boolean.class);
    }

    public void setBooleanSchema(Boolean booleanSchema) {
        Extensions.setPrivateExtension((Extensible)this, (String)"boolean-schema", (Object)booleanSchema);
    }

    public Object get(String propertyName) {
        return this.getProperty(propertyName, Object.class);
    }

    public org.eclipse.microprofile.openapi.models.media.Schema set(String propertyName, Object value) {
        this.setProperty(propertyName, value);
        return this;
    }

    public Map<String, ?> getAll() {
        return super.getAllProperties();
    }

    public void setAll(Map<String, ?> allProperties) {
        super.setAllProperties(allProperties);
    }

    public <T> void setProperty(String propertyName, T value) {
        this.assertObjectSchema();
        super.setProperty(propertyName, value);
    }

    protected <T> T getProperty(String propertyName, Class<T> clazz) {
        if (this.isBooleanSchema()) {
            return null;
        }
        return (T)super.getProperty(propertyName, clazz);
    }

    private boolean isBooleanSchema() {
        return Objects.nonNull(this.getBooleanSchema());
    }

    private void assertObjectSchema() throws UnsupportedOperationException {
        if (this.isBooleanSchema()) {
            throw new UnsupportedOperationException("Schema has a boolean value");
        }
    }
}

