/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.common.annotation.Experimental;
import io.smallrye.mutiny.groups.Gatherers;
import io.smallrye.mutiny.helpers.ParameterValidation;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

@Experimental(value="This API is still being designed and may change in the future")
public interface Gatherer<I, ACC, O> {
    public ACC accumulator();

    public ACC accumulate(ACC var1, I var2);

    public Optional<Extraction<ACC, O>> extract(ACC var1, boolean var2);

    public Optional<O> finalize(ACC var1);

    public static class FinalizerStep<I, ACC, O> {
        private final Supplier<ACC> initialAccumulatorSupplier;
        private final BiFunction<ACC, I, ACC> accumulator;
        private final BiFunction<ACC, Boolean, Optional<Extraction<ACC, O>>> extractor;

        private FinalizerStep(Supplier<ACC> initialAccumulatorSupplier, BiFunction<ACC, I, ACC> accumulator, BiFunction<ACC, Boolean, Optional<Extraction<ACC, O>>> extractor) {
            this.initialAccumulatorSupplier = initialAccumulatorSupplier;
            this.accumulator = accumulator;
            this.extractor = extractor;
        }

        @CheckReturnValue
        public Gatherer<I, ACC, O> finalize(Function<ACC, Optional<O>> finalizer) {
            ParameterValidation.nonNull(finalizer, "finalizer");
            return Gatherers.of(this.initialAccumulatorSupplier, this.accumulator, this.extractor, finalizer);
        }
    }

    public static class ExtractStep<I, ACC> {
        private final Supplier<ACC> initialAccumulatorSupplier;
        private final BiFunction<ACC, I, ACC> accumulator;

        private ExtractStep(Supplier<ACC> initialAccumulatorSupplier, BiFunction<ACC, I, ACC> accumulator) {
            this.initialAccumulatorSupplier = initialAccumulatorSupplier;
            this.accumulator = accumulator;
        }

        @CheckReturnValue
        public <O> FinalizerStep<I, ACC, O> extract(BiFunction<ACC, Boolean, Optional<Extraction<ACC, O>>> extractor) {
            ParameterValidation.nonNull(extractor, "extractor");
            return new FinalizerStep<I, ACC, O>(this.initialAccumulatorSupplier, this.accumulator, extractor);
        }
    }

    public static class InitialAccumulatorStep<I, ACC> {
        private final Supplier<ACC> initialAccumulatorSupplier;

        private InitialAccumulatorStep(Supplier<ACC> initialAccumulatorSupplier) {
            this.initialAccumulatorSupplier = initialAccumulatorSupplier;
        }

        @CheckReturnValue
        public ExtractStep<I, ACC> accumulate(BiFunction<ACC, I, ACC> accumulator) {
            ParameterValidation.nonNull(accumulator, "accumulator");
            return new ExtractStep<I, ACC>(this.initialAccumulatorSupplier, accumulator);
        }
    }

    public static class Builder<I> {
        @CheckReturnValue
        public <ACC> InitialAccumulatorStep<I, ACC> into(Supplier<ACC> initialAccumulatorSupplier) {
            ParameterValidation.nonNull(initialAccumulatorSupplier, "initialAccumulatorSupplier");
            return new InitialAccumulatorStep(initialAccumulatorSupplier);
        }
    }

    public record Extraction<ACC, O>(ACC nextAccumulator, O nextItem) {
        public static <ACC, O> Extraction<ACC, O> of(ACC nextAccumulator, O nextItem) {
            return new Extraction<ACC, O>(nextAccumulator, nextItem);
        }
    }
}

