/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin.k2;

import androidx.compose.compiler.plugins.kotlin.ComposeClassIds;
import androidx.compose.compiler.plugins.kotlin.k2.ComposeErrors;
import androidx.compose.compiler.plugins.kotlin.k2.FirUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.type.FirTypeChecker;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Landroidx/compose/compiler/plugins/kotlin/k2/ComposableAnnotationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeChecker;", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirResolvedTypeRefChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "typeRef", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;)V", "kotlin-compose-compiler-plugin"})
public final class ComposableAnnotationChecker
extends FirTypeChecker<FirResolvedTypeRef> {
    @NotNull
    public static final ComposableAnnotationChecker INSTANCE = new ComposableAnnotationChecker();

    private ComposableAnnotationChecker() {
        super(MppCheckerKind.Common);
    }

    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirResolvedTypeRef typeRef) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        FirAnnotation composableAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId((FirAnnotationContainer)((FirAnnotationContainer)typeRef), (ClassId)ComposeClassIds.INSTANCE.getComposable(), (FirSession)context.getSession());
        if (composableAnnotation == null) {
            return;
        }
        FirTypeRef firTypeRef = typeRef.getDelegatedTypeRef();
        if (Intrinsics.areEqual((Object)(firTypeRef != null && (firTypeRef = firTypeRef.getSource()) != null ? firTypeRef.getKind() : null), (Object)KtFakeSourceElementKind.ArrayTypeFromVarargParameter.INSTANCE) && ConeBuiltinTypeUtilsKt.isNonPrimitiveArray((ConeKotlinType)typeRef.getConeType())) {
            return;
        }
        if (!(typeRef instanceof FirErrorTypeRef) && !FirUtilsKt.isComposableFunction(typeRef.getConeType(), context.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)context), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)composableAnnotation.getSource()), ComposeErrors.INSTANCE.getCOMPOSABLE_INAPPLICABLE_TYPE(), (Object)typeRef.getConeType(), null, (int)16, null);
        }
    }
}

