/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.model.FlexibleTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.RigidTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeArgumentMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeSystemContext;
import org.jetbrains.annotations.NotNull;

public final class AbstractStrictEqualityTypeChecker {
    @NotNull
    public static final AbstractStrictEqualityTypeChecker INSTANCE = new AbstractStrictEqualityTypeChecker();

    private AbstractStrictEqualityTypeChecker() {
    }

    public final boolean strictEqualTypes(@NotNull TypeSystemContext context, @NotNull KotlinTypeMarker a, @NotNull KotlinTypeMarker b) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return this.strictEqualTypesInternal(context, a, b);
    }

    private final boolean strictEqualTypesInternal(TypeSystemContext $this$strictEqualTypesInternal, KotlinTypeMarker a, KotlinTypeMarker b) {
        if (a == b) {
            return true;
        }
        RigidTypeMarker simpleA = $this$strictEqualTypesInternal.asRigidType(a);
        RigidTypeMarker simpleB = $this$strictEqualTypesInternal.asRigidType(b);
        if (simpleA != null && simpleB != null) {
            return this.strictEqualRigidTypes($this$strictEqualTypesInternal, simpleA, simpleB);
        }
        FlexibleTypeMarker flexibleA = $this$strictEqualTypesInternal.asFlexibleType(a);
        FlexibleTypeMarker flexibleB = $this$strictEqualTypesInternal.asFlexibleType(b);
        if (flexibleA != null && flexibleB != null) {
            return this.strictEqualRigidTypes($this$strictEqualTypesInternal, $this$strictEqualTypesInternal.lowerBound(flexibleA), $this$strictEqualTypesInternal.lowerBound(flexibleB)) && this.strictEqualRigidTypes($this$strictEqualTypesInternal, $this$strictEqualTypesInternal.upperBound(flexibleA), $this$strictEqualTypesInternal.upperBound(flexibleB));
        }
        return false;
    }

    private final boolean strictEqualRigidTypes(TypeSystemContext $this$strictEqualRigidTypes, RigidTypeMarker a, RigidTypeMarker b) {
        if ($this$strictEqualRigidTypes.argumentsCount(a) != $this$strictEqualRigidTypes.argumentsCount(b) || $this$strictEqualRigidTypes.isMarkedNullable(a) != $this$strictEqualRigidTypes.isMarkedNullable(b) || $this$strictEqualRigidTypes.isDefinitelyNotNullType(a) != $this$strictEqualRigidTypes.isDefinitelyNotNullType(b) || !$this$strictEqualRigidTypes.areEqualTypeConstructors($this$strictEqualRigidTypes.typeConstructor(a), $this$strictEqualRigidTypes.typeConstructor(b))) {
            return false;
        }
        if ($this$strictEqualRigidTypes.identicalArguments(a, b)) {
            return true;
        }
        int n = $this$strictEqualRigidTypes.argumentsCount(a);
        for (int i = 0; i < n; ++i) {
            TypeArgumentMarker aArg = $this$strictEqualRigidTypes.getArgument(a, i);
            TypeArgumentMarker bArg = $this$strictEqualRigidTypes.getArgument(b, i);
            if ($this$strictEqualRigidTypes.isStarProjection(aArg) != $this$strictEqualRigidTypes.isStarProjection(bArg)) {
                return false;
            }
            if ($this$strictEqualRigidTypes.isStarProjection(aArg)) continue;
            if ($this$strictEqualRigidTypes.getVariance(aArg) != $this$strictEqualRigidTypes.getVariance(bArg)) {
                return false;
            }
            KotlinTypeMarker kotlinTypeMarker = $this$strictEqualRigidTypes.getType(aArg);
            Intrinsics.checkNotNull((Object)kotlinTypeMarker);
            KotlinTypeMarker kotlinTypeMarker2 = $this$strictEqualRigidTypes.getType(bArg);
            Intrinsics.checkNotNull((Object)kotlinTypeMarker2);
            if (this.strictEqualTypesInternal($this$strictEqualRigidTypes, kotlinTypeMarker, kotlinTypeMarker2)) continue;
            return false;
        }
        return true;
    }
}

