/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.command;

import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.activitydiagram3.command.CommandActivity3;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.skin.ColorParam;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandRepeat3
extends SingleLineCommand2<ActivityDiagram3> {
    public CommandRepeat3() {
        super(CommandRepeat3.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandRepeat3.class.getName(), RegexLeaf.start(), StereotypePattern.optional("STEREO1"), ColorParser.exp4(), new RegexLeaf("repeat"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf(1, "LABEL", ":(.*?)")), StereotypePattern.optional("STEREO2"), new RegexOptional((IRegex)new RegexLeaf(2, "STYLE", CommandActivity3.endingGroup())), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeArg(ActivityDiagram3 diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
        String s = arg.get("COLOR", 0);
        HColor color = s == null ? null : diagram.getSkinParam().getIHtmlColorSet().getColor(s);
        Display label = Display.getWithNewlines(diagram.getPragma(), arg.get("LABEL", 0));
        String styleString = arg.get("STYLE", 0);
        BoxStyle boxStyle = styleString == null ? BoxStyle.PLAIN : BoxStyle.fromString(styleString);
        BoxStyle.checkDeprecatedWarning(diagram, styleString);
        Colors colors = CommandRepeat3.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        String stereo = arg.getLazzy("STEREO", 0);
        if (stereo == null) {
            stereo = arg.get("STYLE", 1);
        }
        Stereotype stereotype = null;
        if (stereo != null) {
            stereotype = Stereotype.build(stereo);
            colors = colors.applyStereotype(stereotype, diagram.getSkinParam(), ColorParam.activityBackground);
        }
        diagram.startRepeat(color, label, boxStyle, colors, stereotype);
        return CommandExecutionResult.ok();
    }
}

