/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.code;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import net.sourceforge.plantuml.code.ByteArray;
import net.sourceforge.plantuml.code.Compression;
import net.sourceforge.plantuml.code.NoPlantumlCompressionException;

public class CompressionGZip
implements Compression {
    @Override
    public byte[] compress(byte[] in) {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public ByteArray decompress(byte[] input) throws NoPlantumlCompressionException {
        try (GZIPInputStream gzip = new GZIPInputStream(new ByteArrayInputStream(input));){
            ByteArray byteArray;
            byte[] buffer = new byte[10000];
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                int len;
                while ((len = gzip.read(buffer)) > 0) {
                    baos.write(buffer, 0, len);
                    if (baos.size() <= 200000) continue;
                    throw new NoPlantumlCompressionException("Gzip error");
                }
                byteArray = ByteArray.from(baos.toByteArray());
            }
            return byteArray;
        }
        catch (IOException e) {
            throw new NoPlantumlCompressionException(e);
        }
    }
}

