/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import net.sourceforge.plantuml.klimt.LineBreakStrategy;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.creole.Sheet;
import net.sourceforge.plantuml.klimt.creole.SheetBlock1;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.project.ToTaskDraw;
import net.sourceforge.plantuml.project.core.GSide;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.draw.TaskDraw;
import net.sourceforge.plantuml.project.lang.CenterBorderColor;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.skin.Pragma;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.image.Opale;
import net.sourceforge.plantuml.url.Url;

public abstract class AbstractTaskDraw
implements TaskDraw {
    private CenterBorderColor colors;
    private int completion = 100;
    protected Url url;
    protected Display note;
    protected Stereotype noteStereotype;
    protected final TimeScale timeScale;
    private Real y;
    protected final String prettyDisplay;
    protected final Day start;
    private final StyleBuilder styleBuilder;
    private final Task task;
    private final ToTaskDraw toTaskDraw;
    private final ISkinParam skinParam;

    public final String toString() {
        return super.toString() + " " + this.task;
    }

    @Override
    public final void setColorsAndCompletion(CenterBorderColor colors, int completion, Url url, Display note, Stereotype noteStereotype) {
        this.colors = colors;
        this.completion = completion;
        this.url = url;
        this.note = note;
        this.noteStereotype = noteStereotype;
    }

    public AbstractTaskDraw(TimeScale timeScale, Real y, String prettyDisplay, Day start, Task task, ToTaskDraw toTaskDraw, StyleBuilder styleBuilder, ISkinParam skinParam) {
        this.y = y;
        this.skinParam = skinParam;
        this.styleBuilder = styleBuilder;
        this.toTaskDraw = toTaskDraw;
        this.start = start;
        this.prettyDisplay = prettyDisplay;
        this.timeScale = timeScale;
        this.task = task;
    }

    abstract StyleSignature getStyleSignature();

    private StyleSignatureBasic getStyleSignatureUnstarted() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.ganttDiagram, SName.task, SName.unstarted);
    }

    protected final HColor getLineColor() {
        HColor unstarted = this.getStyleSignatureUnstarted().getMergedStyle(this.styleBuilder).value(PName.LineColor).asColor(this.getColorSet());
        HColor regular = this.getStyle().value(PName.LineColor).asColor(this.getColorSet());
        return HColors.unlinear(unstarted, regular, this.completion);
    }

    protected final HColor getBackgroundColor() {
        HColor unstarted = this.getStyleSignatureUnstarted().getMergedStyle(this.styleBuilder).value(PName.BackGroundColor).asColor(this.getColorSet());
        HColor regular = this.getStyle().value(PName.BackGroundColor).asColor(this.getColorSet());
        return HColors.unlinear(unstarted, regular, this.completion);
    }

    protected final FontConfiguration getFontConfiguration() {
        return this.getStyle().getFontConfiguration(this.getColorSet());
    }

    protected final Style getStyle() {
        return this.getStyleSignature().getMergedStyle(this.styleBuilder);
    }

    @Override
    public final double getTitleWidth(StringBounder stringBounder) {
        Style style = this.getStyleSignature().getMergedStyle(this.getStyleBuilder());
        ClockwiseTopRightBottomLeft margin = style.getMargin();
        return margin.getLeft() + this.getTitle().calculateDimension(stringBounder).getWidth() + margin.getRight();
    }

    protected abstract TextBlock getTitle();

    protected abstract double getShapeHeight(StringBounder var1);

    @Override
    public final double getFullHeightTask(StringBounder stringBounder) {
        Style style = this.getStyle();
        ClockwiseTopRightBottomLeft margin = style.getMargin();
        return margin.getTop() + this.getShapeHeight(stringBounder) + margin.getBottom();
    }

    @Override
    public final TaskDraw getTrueRow() {
        return this.toTaskDraw.getTaskDraw(this.task.getRow());
    }

    @Override
    public final Real getY(StringBounder stringBounder) {
        if (this.task.getRow() == null) {
            return this.y;
        }
        return this.getTrueRow().getY(stringBounder);
    }

    @Override
    public final Task getTask() {
        return this.task;
    }

    @Override
    public double getY(StringBounder stringBounder, GSide side) {
        Style style = this.getStyle();
        ClockwiseTopRightBottomLeft margin = style.getMargin();
        double y1 = margin.getTop() + this.getY(stringBounder).getCurrentValue();
        double y2 = y1 + this.getShapeHeight(stringBounder);
        if (side.isTop()) {
            return y1;
        }
        if (side.isBottom()) {
            return y2;
        }
        return (y1 + y2) / 2.0;
    }

    protected final StyleBuilder getStyleBuilder() {
        return this.styleBuilder;
    }

    protected final HColorSet getColorSet() {
        return this.toTaskDraw.getIHtmlColorSet();
    }

    protected CenterBorderColor getColors() {
        return this.colors;
    }

    protected int getCompletion() {
        return this.completion;
    }

    protected Pragma getPragma() {
        return this.skinParam.getPragma();
    }

    protected Opale getOpaleNote() {
        Style style = StyleSignatureBasic.of(SName.root, SName.element, SName.ganttDiagram, SName.note).withTOBECHANGED(this.noteStereotype).getMergedStyle(this.getStyleBuilder());
        FontConfiguration fc = style.getFontConfiguration(this.getColorSet());
        HorizontalAlignment horizontalAlignment = style.value(PName.HorizontalAlignment).asHorizontalAlignment();
        Sheet sheet = this.skinParam.sheet(fc, horizontalAlignment, CreoleMode.FULL).createSheet(this.note);
        double padding = style.value(PName.Padding).asDouble();
        SheetBlock1 sheet1 = new SheetBlock1(sheet, LineBreakStrategy.NONE, padding);
        HColor noteBackgroundColor = style.value(PName.BackGroundColor).asColor(this.getColorSet());
        HColor borderColor = style.value(PName.LineColor).asColor(this.getColorSet());
        double shadowing = style.getShadowing();
        return new Opale(shadowing, borderColor, noteBackgroundColor, sheet1, false, style.getStroke());
    }

    protected void drawNote(UGraphic ug) {
        if (this.note == null) {
            return;
        }
        this.getOpaleNote().drawU(ug);
    }
}

