/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.EntityPortion;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.abel.LineConfigurable;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.TextBlockCucaJSon;
import net.sourceforge.plantuml.klimt.Shadowable;
import net.sourceforge.plantuml.klimt.UGroup;
import net.sourceforge.plantuml.klimt.UGroupType;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.creole.Stencil;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.UGraphicStencil;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.FontParam;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.PlacementStrategyY1Y2;
import net.sourceforge.plantuml.klimt.geom.ULayoutGroup;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Ports;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.WithPorts;
import net.sourceforge.plantuml.text.Guillemet;
import net.sourceforge.plantuml.url.Url;

public class EntityImageJson
extends AbstractEntityImage
implements Stencil,
WithPorts {
    private final TextBlock name;
    private final TextBlock stereo;
    private final TextBlock entries;
    private final Url url;
    private final double roundCorner;
    private final LineConfigurable lineConfig;
    private int marginEmptyFieldsOrMethod = 13;
    private int xMarginCircle = 5;

    public EntityImageJson(Entity entity, PortionShower portionShower) {
        super(entity);
        this.lineConfig = entity;
        Stereotype stereotype = entity.getStereotype();
        this.roundCorner = this.getStyle().value(PName.RoundCorner).asDouble();
        FontConfiguration fcHeader = this.getStyleHeader().getFontConfiguration(this.getSkinParam().getIHtmlColorSet());
        this.name = TextBlockUtils.withMargin(entity.getDisplay().create(fcHeader, HorizontalAlignment.CENTER, this.getSkinParam()), 2.0, 2.0);
        this.stereo = stereotype == null || stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR) == null || !portionShower.showPortion(EntityPortion.STEREOTYPE, entity) ? null : Display.create(stereotype.getLabels(this.getSkinParam().guillemet())).create(FontConfiguration.create(this.getSkinParam(), FontParam.OBJECT_STEREOTYPE, stereotype), HorizontalAlignment.CENTER, this.getSkinParam());
        FontConfiguration fontConfiguration = this.getStyle().getFontConfiguration(this.getSkinParam().getIHtmlColorSet());
        this.entries = entity.getBodier().getBody(this.getSkinParam(), false, false, entity.getStereotype(), this.getStyle(), fontConfiguration);
        this.url = entity.getUrl99();
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        XDimension2D dimTitle = this.getTitleDimension(stringBounder);
        return ((WithPorts)((Object)this.entries)).getPorts(stringBounder).translateY(dimTitle.getHeight());
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        Style style;
        double minimumWidth;
        XDimension2D dimTitle = this.getTitleDimension(stringBounder);
        XDimension2D dimFields = this.entries.calculateDimension(stringBounder);
        double width = Math.max(dimFields.getWidth(), dimTitle.getWidth() + (double)(2 * this.xMarginCircle));
        if (width < (minimumWidth = (style = this.getStyle()).value(PName.MinimumWidth).asDouble())) {
            width = minimumWidth;
        }
        double height = this.getMethodOrFieldHeight(dimFields) + dimTitle.getHeight();
        return new XDimension2D(width, height);
    }

    private Style getStyle() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.objectDiagram, SName.json).withTOBECHANGED(this.getEntity().getStereotype()).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    private Style getStyleHeader() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.objectDiagram, SName.json, SName.header).withTOBECHANGED(this.getEntity().getStereotype()).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    @Override
    public final void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dimTotal = this.calculateDimension(stringBounder);
        XDimension2D dimTitle = this.getTitleDimension(stringBounder);
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        URectangle rect = URectangle.build(widthTotal, heightTotal).rounded(this.roundCorner);
        HColor headerBackcolor = this.getEntity().getColors().getColor(ColorType.HEADER);
        HColor backcolor = this.getEntity().getColors().getColor(ColorType.BACK);
        Style style = this.getStyle();
        HColor borderColor = style.value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
        if (headerBackcolor == null) {
            HColor hColor = headerBackcolor = backcolor == null ? this.getStyleHeader().value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet()) : backcolor;
        }
        if (backcolor == null) {
            backcolor = style.value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet());
        }
        rect.setDeltaShadow(style.getShadowing());
        UStroke stroke = style.getStroke();
        ug = ug.apply(borderColor).apply(backcolor.bg());
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        UGroup group = new UGroup(this.getEntity().getLocation());
        group.put(UGroupType.CLASS, "entity");
        group.put(UGroupType.ID, "entity_" + this.getEntity().getName());
        group.put(UGroupType.DATA_ENTITY, this.getEntity().getName());
        group.put(UGroupType.DATA_UID, this.getEntity().getUid());
        group.put(UGroupType.DATA_QUALIFIED_NAME, this.getEntity().getQuark().getQualifiedName());
        ug.startGroup(group);
        ug.apply(stroke).draw(rect);
        if (headerBackcolor != null && !backcolor.equals(headerBackcolor)) {
            Shadowable rect2 = URectangle.build(widthTotal, dimTitle.getHeight()).halfRounded(this.roundCorner);
            UGraphic ugHeader = ug.apply(headerBackcolor.bg());
            ugHeader.apply(stroke).draw(rect2);
        }
        ULayoutGroup header = new ULayoutGroup(new PlacementStrategyY1Y2(ug.getStringBounder()));
        if (this.stereo != null) {
            header.add(this.stereo);
        }
        header.add(this.name);
        header.drawU(ug, dimTotal.getWidth(), dimTitle.getHeight());
        UGraphic ug2 = UGraphicStencil.create(ug, this, stroke);
        ((TextBlockCucaJSon)this.entries).setTotalWidth(dimTotal.getWidth());
        this.entries.drawU(ug2.apply(UTranslate.dy(dimTitle.getHeight())));
        ug.closeGroup();
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    private double getMethodOrFieldHeight(XDimension2D dim) {
        double fieldsHeight = dim.getHeight();
        if (fieldsHeight == 0.0 && this.getEntity().getLeafType() != LeafType.MAP) {
            return this.marginEmptyFieldsOrMethod;
        }
        return fieldsHeight;
    }

    private XDimension2D getTitleDimension(StringBounder stringBounder) {
        return this.getNameAndSteretypeDimension(stringBounder);
    }

    private XDimension2D getNameAndSteretypeDimension(StringBounder stringBounder) {
        XDimension2D nameDim = this.name.calculateDimension(stringBounder);
        XDimension2D stereoDim = this.stereo == null ? new XDimension2D(0.0, 0.0) : this.stereo.calculateDimension(stringBounder);
        XDimension2D nameAndStereo = new XDimension2D(Math.max(nameDim.getWidth(), stereoDim.getWidth()), nameDim.getHeight() + stereoDim.getHeight());
        return nameAndStereo;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE_HTML_FOR_PORTS;
    }

    @Override
    public double getStartingX(StringBounder stringBounder, double y) {
        return 0.0;
    }

    @Override
    public double getEndingX(StringBounder stringBounder, double y) {
        return this.calculateDimension(stringBounder).getWidth();
    }
}

