/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common.networksimplex;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.elk.alg.common.networksimplex.NEdge;
import org.eclipse.elk.alg.common.networksimplex.NGraph;
import org.eclipse.elk.alg.common.networksimplex.NNode;
import org.eclipse.elk.core.util.BasicProgressMonitor;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.Pair;

public final class NetworkSimplex {
    private int[] previousLayeringNodeCounts;
    private boolean balance = false;
    private int iterationLimit = Integer.MAX_VALUE;
    private static final int REMOVE_SUBTREES_THRESH = 40;
    private static final double FUZZY_ST_ZERO = -1.0E-10;
    private NGraph graph;
    private List<NEdge> edges;
    private Set<NEdge> treeEdges;
    private List<NNode> sources;
    private boolean[] edgeVisited;
    private int postOrder;
    private int[] poID;
    private int[] lowestPoID;
    private double[] cutvalue;
    private Deque<Pair<NNode, NEdge>> subtreeNodesStack;

    private NetworkSimplex() {
    }

    public static NetworkSimplex forGraph(NGraph graph) {
        NetworkSimplex ns = new NetworkSimplex();
        ns.graph = graph;
        return ns;
    }

    public NetworkSimplex withBalancing(boolean doBalance) {
        this.balance = doBalance;
        return this;
    }

    public NetworkSimplex withPreviousLayering(int[] considerPreviousLayering) {
        this.previousLayeringNodeCounts = considerPreviousLayering;
        return this;
    }

    public NetworkSimplex withIterationLimit(int limit) {
        this.iterationLimit = limit;
        return this;
    }

    private void initialize() {
        int numNodes = this.graph.nodes.size();
        for (NNode n : this.graph.nodes) {
            n.treeNode = false;
        }
        this.poID = new int[numNodes];
        this.lowestPoID = new int[numNodes];
        this.sources = Lists.newArrayList();
        int index = 0;
        ArrayList<NEdge> theEdges = Lists.newArrayList();
        for (NNode node : this.graph.nodes) {
            node.internalId = index++;
            if (node.getIncomingEdges().size() == 0) {
                this.sources.add(node);
            }
            theEdges.addAll(node.getOutgoingEdges());
        }
        int counter = 0;
        for (NEdge edge : theEdges) {
            edge.internalId = counter++;
            edge.treeEdge = false;
        }
        int numEdges = theEdges.size();
        if (this.cutvalue == null || this.cutvalue.length < numEdges) {
            this.cutvalue = new double[numEdges];
            this.edgeVisited = new boolean[numEdges];
        } else {
            Arrays.fill(this.edgeVisited, false);
        }
        this.edges = theEdges;
        this.treeEdges = Sets.newLinkedHashSetWithExpectedSize(this.edges.size());
        this.postOrder = 1;
    }

    private void dispose() {
        this.cutvalue = null;
        this.edges = null;
        this.treeEdges = null;
        this.edgeVisited = null;
        this.lowestPoID = null;
        this.poID = null;
        this.sources = null;
        this.subtreeNodesStack = null;
    }

    public void execute() {
        this.execute(new BasicProgressMonitor());
    }

    public void execute(IElkProgressMonitor monitor) {
        boolean removeSubtrees;
        monitor.begin("Network simplex", 1.0f);
        if (this.graph.nodes.size() < 1) {
            monitor.done();
            return;
        }
        for (NNode node : this.graph.nodes) {
            node.layer = 0;
        }
        boolean bl = removeSubtrees = this.graph.nodes.size() >= 40;
        if (removeSubtrees) {
            this.removeSubtrees();
        }
        this.initialize();
        this.feasibleTree();
        NEdge e = this.leaveEdge();
        int iter = 0;
        while (e != null && iter < this.iterationLimit) {
            this.exchange(e, this.enterEdge(e));
            e = this.leaveEdge();
            ++iter;
        }
        if (removeSubtrees) {
            this.reattachSubtrees();
        }
        if (this.balance) {
            this.balance(this.normalize());
        } else {
            this.normalize();
        }
        this.dispose();
        monitor.done();
    }

    private void removeSubtrees() {
        this.subtreeNodesStack = new ArrayDeque<Pair<NNode, NEdge>>();
        LinkedList<NNode> leafs = Lists.newLinkedList();
        for (NNode node : this.graph.nodes) {
            if (node.getConnectedEdges().size() != 1) continue;
            leafs.add(node);
        }
        while (!leafs.isEmpty()) {
            NNode node;
            node = (NNode)leafs.poll();
            if (node.getConnectedEdges().size() == 0) continue;
            NEdge edge = node.getConnectedEdges().get(0);
            boolean isOutEdge = node.getOutgoingEdges().size() > 0;
            NNode other = edge.getOther(node);
            if (isOutEdge) {
                other.getIncomingEdges().remove(edge);
            } else {
                other.getOutgoingEdges().remove(edge);
            }
            if (other.getConnectedEdges().size() == 1) {
                leafs.add(other);
            }
            Pair<NNode, NEdge> leafy = Pair.of(node, edge);
            this.subtreeNodesStack.push(leafy);
            this.graph.nodes.remove(node);
        }
    }

    private void reattachSubtrees() {
        while (!this.subtreeNodesStack.isEmpty()) {
            Pair<NNode, NEdge> leafy = this.subtreeNodesStack.pop();
            NNode node = leafy.getFirst();
            NEdge edge = leafy.getSecond();
            NNode placed = edge.getOther(node);
            if (edge.target == node) {
                placed.getOutgoingEdges().add(edge);
                node.layer = placed.layer + edge.delta;
            } else {
                placed.getIncomingEdges().add(edge);
                node.layer = placed.layer - edge.delta;
            }
            this.graph.nodes.add(node);
        }
    }

    private void feasibleTree() {
        this.layeringTopologicalNumbering(this.sources);
        if (this.edges.size() > 0) {
            Arrays.fill(this.edgeVisited, false);
            while (this.tightTreeDFS(this.graph.nodes.iterator().next()) < this.graph.nodes.size()) {
                NEdge e = this.minimalSlack();
                int slack = e.getTarget().layer - e.getSource().layer - e.delta;
                if (e.getTarget().treeNode) {
                    slack = -slack;
                }
                for (NNode node : this.graph.nodes) {
                    if (!node.treeNode) continue;
                    node.layer += slack;
                }
                Arrays.fill(this.edgeVisited, false);
            }
            Arrays.fill(this.edgeVisited, false);
            this.postorderTraversal(this.graph.nodes.iterator().next());
            this.cutvalues();
        }
    }

    private void layeringTopologicalNumbering(List<NNode> initialRootNodes) {
        int[] incident = new int[this.graph.nodes.size()];
        for (NNode node : this.graph.nodes) {
            int n = node.internalId;
            incident[n] = incident[n] + node.getIncomingEdges().size();
        }
        LinkedList<NNode> roots = Lists.newLinkedList(initialRootNodes);
        while (!roots.isEmpty()) {
            NNode node = roots.poll();
            for (NEdge edge : node.getOutgoingEdges()) {
                NNode target = edge.getTarget();
                target.layer = Math.max(target.layer, node.layer + edge.delta);
                int n = target.internalId;
                incident[n] = incident[n] - 1;
                if (incident[target.internalId] != 0) continue;
                roots.add(target);
            }
        }
    }

    private Pair<Integer, Integer> minimalSpan(NNode node) {
        int minSpanOut = Integer.MAX_VALUE;
        int minSpanIn = Integer.MAX_VALUE;
        for (NEdge edge : node.getConnectedEdges()) {
            int currentSpan = edge.getTarget().layer - edge.getSource().layer;
            if (edge.getTarget() == node && currentSpan < minSpanIn) {
                minSpanIn = currentSpan;
                continue;
            }
            if (currentSpan >= minSpanOut) continue;
            minSpanOut = currentSpan;
        }
        if (minSpanIn == Integer.MAX_VALUE) {
            minSpanIn = -1;
        }
        if (minSpanOut == Integer.MAX_VALUE) {
            minSpanOut = -1;
        }
        return new Pair<Integer, Integer>(minSpanIn, minSpanOut);
    }

    private int tightTreeDFS(NNode node) {
        int nodeCount = 1;
        node.treeNode = true;
        NNode opposite = null;
        for (NEdge edge : node.getConnectedEdges()) {
            if (this.edgeVisited[edge.internalId]) continue;
            this.edgeVisited[edge.internalId] = true;
            opposite = edge.getOther(node);
            if (edge.treeEdge) {
                nodeCount += this.tightTreeDFS(opposite);
                continue;
            }
            if (opposite.treeNode || edge.delta != edge.getTarget().layer - edge.getSource().layer) continue;
            edge.treeEdge = true;
            this.treeEdges.add(edge);
            nodeCount += this.tightTreeDFS(opposite);
        }
        return nodeCount;
    }

    private NEdge minimalSlack() {
        int minSlack = Integer.MAX_VALUE;
        NEdge minSlackEdge = null;
        for (NEdge edge : this.edges) {
            int curSlack;
            if (!(edge.getSource().treeNode ^ edge.getTarget().treeNode) || (curSlack = edge.getTarget().layer - edge.getSource().layer - edge.delta) >= minSlack) continue;
            minSlack = curSlack;
            minSlackEdge = edge;
        }
        return minSlackEdge;
    }

    private int postorderTraversal(NNode node) {
        int lowest = Integer.MAX_VALUE;
        for (NEdge edge : node.getConnectedEdges()) {
            if (!edge.treeEdge || this.edgeVisited[edge.internalId]) continue;
            this.edgeVisited[edge.internalId] = true;
            lowest = Math.min(lowest, this.postorderTraversal(edge.getOther(node)));
        }
        this.poID[node.internalId] = this.postOrder;
        this.lowestPoID[node.internalId] = Math.min(lowest, this.postOrder++);
        return this.lowestPoID[node.internalId];
    }

    private boolean isInHead(NNode node, NEdge edge) {
        NNode source = edge.getSource();
        NNode target = edge.getTarget();
        if (this.lowestPoID[source.internalId] <= this.poID[node.internalId] && this.poID[node.internalId] <= this.poID[source.internalId] && this.lowestPoID[target.internalId] <= this.poID[node.internalId] && this.poID[node.internalId] <= this.poID[target.internalId]) {
            return this.poID[source.internalId] >= this.poID[target.internalId];
        }
        return this.poID[source.internalId] < this.poID[target.internalId];
    }

    private void cutvalues() {
        ArrayList<NNode> leafs = Lists.newArrayList();
        for (NNode node : this.graph.nodes) {
            int treeEdgeCount = 0;
            node.unknownCutvalues.clear();
            for (NEdge edge : node.getConnectedEdges()) {
                if (!edge.treeEdge) continue;
                node.unknownCutvalues.add(edge);
                ++treeEdgeCount;
            }
            if (treeEdgeCount != true) continue;
            leafs.add(node);
        }
        for (NNode node : leafs) {
            while (node.unknownCutvalues.size() == 1) {
                NEdge toDetermine = node.unknownCutvalues.iterator().next();
                this.cutvalue[toDetermine.internalId] = toDetermine.weight;
                NNode source = toDetermine.getSource();
                NNode target = toDetermine.getTarget();
                for (NEdge edge : node.getConnectedEdges()) {
                    if (edge.equals(toDetermine)) continue;
                    if (edge.treeEdge) {
                        if (source.equals(edge.getSource()) || target.equals(edge.getTarget())) {
                            int n = toDetermine.internalId;
                            this.cutvalue[n] = this.cutvalue[n] - (this.cutvalue[edge.internalId] - edge.weight);
                            continue;
                        }
                        int n = toDetermine.internalId;
                        this.cutvalue[n] = this.cutvalue[n] + (this.cutvalue[edge.internalId] - edge.weight);
                        continue;
                    }
                    if (node.equals(source)) {
                        if (edge.getSource().equals(node)) {
                            int n = toDetermine.internalId;
                            this.cutvalue[n] = this.cutvalue[n] + edge.weight;
                            continue;
                        }
                        int n = toDetermine.internalId;
                        this.cutvalue[n] = this.cutvalue[n] - edge.weight;
                        continue;
                    }
                    if (edge.getSource().equals(node)) {
                        int n = toDetermine.internalId;
                        this.cutvalue[n] = this.cutvalue[n] - edge.weight;
                        continue;
                    }
                    int n = toDetermine.internalId;
                    this.cutvalue[n] = this.cutvalue[n] + edge.weight;
                }
                source.unknownCutvalues.remove(toDetermine);
                target.unknownCutvalues.remove(toDetermine);
                node = source.equals(node) ? toDetermine.getTarget() : toDetermine.getSource();
            }
        }
    }

    private NEdge leaveEdge() {
        for (NEdge edge : this.treeEdges) {
            if (!edge.treeEdge || !(this.cutvalue[edge.internalId] < -1.0E-10)) continue;
            return edge;
        }
        return null;
    }

    private NEdge enterEdge(NEdge leave) {
        if (!leave.treeEdge) {
            throw new IllegalArgumentException("The input edge is not a tree edge.");
        }
        NEdge replace = null;
        int repSlack = Integer.MAX_VALUE;
        for (NEdge edge : this.edges) {
            int slack;
            NNode source = edge.getSource();
            NNode target = edge.getTarget();
            if (!this.isInHead(source, leave) || this.isInHead(target, leave) || (slack = target.layer - source.layer - edge.delta) >= repSlack) continue;
            repSlack = slack;
            replace = edge;
        }
        return replace;
    }

    private void exchange(NEdge leave, NEdge enter) {
        if (!leave.treeEdge) {
            throw new IllegalArgumentException("Given leave edge is no tree edge.");
        }
        if (enter.treeEdge) {
            throw new IllegalArgumentException("Given enter edge is a tree edge already.");
        }
        leave.treeEdge = false;
        this.treeEdges.remove(leave);
        enter.treeEdge = true;
        this.treeEdges.add(enter);
        int delta = enter.getTarget().layer - enter.getSource().layer - enter.delta;
        if (!this.isInHead(enter.getTarget(), leave)) {
            delta = -delta;
        }
        for (NNode node : this.graph.nodes) {
            if (this.isInHead(node, leave)) continue;
            node.layer += delta;
        }
        this.postOrder = 1;
        Arrays.fill(this.edgeVisited, false);
        this.postorderTraversal(this.graph.nodes.iterator().next());
        this.cutvalues();
    }

    private int[] normalize() {
        int highest = Integer.MIN_VALUE;
        int lowest = Integer.MAX_VALUE;
        for (NNode node : this.graph.nodes) {
            lowest = Math.min(lowest, node.layer);
            highest = Math.max(highest, node.layer);
        }
        int[] filling = new int[highest - lowest + 1];
        for (NNode node : this.graph.nodes) {
            node.layer -= lowest;
            int n = node.layer;
            filling[n] = filling[n] + 1;
        }
        int layerID = 0;
        if (this.previousLayeringNodeCounts != null) {
            int[] nArray = this.previousLayeringNodeCounts;
            int n = this.previousLayeringNodeCounts.length;
            int n2 = 0;
            while (n2 < n) {
                int nodeCntInLayer = nArray[n2];
                int n3 = layerID++;
                filling[n3] = filling[n3] + nodeCntInLayer;
                if (filling.length == layerID) break;
                ++n2;
            }
        }
        return filling;
    }

    private void balance(int[] filling) {
        Pair<Integer, Integer> range = null;
        for (NNode node : this.graph.nodes) {
            if (node.getIncomingEdges().size() != node.getOutgoingEdges().size()) continue;
            int newLayer = node.layer;
            range = this.minimalSpan(node);
            int i = node.layer - range.getFirst() + 1;
            while (i < node.layer + range.getSecond()) {
                if (filling[i] < filling[newLayer]) {
                    newLayer = i;
                }
                ++i;
            }
            if (filling[newLayer] >= filling[node.layer]) continue;
            int n = node.layer;
            filling[n] = filling[n] - 1;
            int n2 = newLayer;
            filling[n2] = filling[n2] + 1;
            node.layer = newLayer;
        }
    }
}

