/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.text.DecimalFormat;
import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.util.InterningSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakInterningHashSet<E>
extends AbstractSet<E>
implements InterningSet<E>,
Serializable {
    protected static final long serialVersionUID = 1L;
    protected static final Entry<Object> NULL_ENTRY = new Entry();
    protected static final int[] PRIME_CAPACITIES = new int[]{17, 37, 67, 131, 257, 521, 1031, 2053, 4099, 8209, 16411, 32771, 65537, 131101, 262147, 524309, 0x100007, 0x200011, 0x40000F, 0x800009, 16777259, 0x2000023, 0x400000F, 134217757, 0x10000003, 0x2000000B, 0x40000003, 2147483629};
    protected int size;
    protected transient int capacityIndex;
    protected transient boolean containsNull;
    protected transient int threshold;
    protected transient int modCount;
    protected transient Entry<E>[] entries;
    protected transient ReferenceQueue<E> internalQueue;
    protected final transient ReferenceQueue<Object> externalQueue;

    public WeakInterningHashSet() {
        this(0);
    }

    public WeakInterningHashSet(int minimumCapacity) {
        this(minimumCapacity, null);
    }

    WeakInterningHashSet(int minimumCapacity, ReferenceQueue<Object> queue) {
        this.doGrow(minimumCapacity);
        this.externalQueue = queue;
        if (queue == null) {
            this.internalQueue = new ReferenceQueue();
        }
    }

    @Override
    public int size() {
        if (this.internalQueue != null) {
            this.cleanup();
        }
        return this.size;
    }

    public void grow(int minimumCapacity) {
        int currentCapacity = PRIME_CAPACITIES[this.capacityIndex];
        if (currentCapacity < minimumCapacity) {
            this.doGrow(minimumCapacity);
        }
    }

    private final void doGrow(int minimumCapacity) {
        int i = 0;
        int length = PRIME_CAPACITIES.length;
        while (i < length) {
            int capacity = PRIME_CAPACITIES[i];
            if (capacity >= minimumCapacity) {
                this.capacityIndex = i;
                ++this.modCount;
                this.rehash(this.newEntries(capacity));
                break;
            }
            ++i;
        }
    }

    protected int hashCode(E object) {
        return object.hashCode();
    }

    protected boolean equals(E object, E otherObject) {
        return object.equals(otherObject);
    }

    protected E asInstance(Object object) {
        return (E)object;
    }

    protected Entry<E>[] newEntries(int capacity) {
        Entry[] newEntries = new Entry[capacity];
        return newEntries;
    }

    protected boolean ensureCapacity() {
        if (this.size > this.threshold) {
            this.rehash(this.newEntries(PRIME_CAPACITIES[++this.capacityIndex]));
            return true;
        }
        return false;
    }

    final void rehash(Entry<E>[] newEntries) {
        Entry<E>[] oldEntries = this.entries;
        this.entries = newEntries;
        int newCapacity = newEntries.length;
        if (oldEntries != null) {
            int i = 0;
            int length = oldEntries.length;
            while (i < length) {
                Entry<E> entry = oldEntries[i];
                while (entry != null) {
                    Entry nextEntry = entry.next;
                    this.putEntry(WeakInterningHashSet.index(entry.hashCode, newCapacity), entry);
                    entry = nextEntry;
                }
                ++i;
            }
        }
        this.threshold = newCapacity * 3 / 4;
    }

    protected void cleanup() {
        Reference<E> reference;
        while ((reference = this.internalQueue.poll()) != null) {
            Entry entry = (Entry)reference;
            this.removeEntry(entry);
            entry.clear();
        }
        return;
    }

    @Override
    public boolean remove(Object object) {
        if (this.internalQueue != null) {
            this.cleanup();
        }
        if (object == null) {
            if (!this.containsNull) {
                return false;
            }
            this.containsNull = false;
            ++this.modCount;
            --this.size;
            return true;
        }
        E instance = this.asInstance(object);
        if (instance == null) {
            return false;
        }
        int hashCode = this.hashCode(instance);
        int index = WeakInterningHashSet.index(hashCode, this.entries.length);
        Entry<E> entry = this.entries[index];
        while (entry != null) {
            Object otherObject;
            if (hashCode == entry.hashCode && (instance == (otherObject = entry.get()) || this.equals(instance, otherObject))) {
                if (this.internalQueue != null) {
                    this.removeEntry(entry);
                    entry.clear();
                } else {
                    entry.clear();
                }
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    @Override
    public void clear() {
        this.containsNull = false;
        this.size = 0;
        int i = 0;
        while (i < this.entries.length) {
            this.entries[i] = null;
            ++i;
        }
    }

    @Override
    public boolean add(E object) {
        if (this.internalQueue != null) {
            this.cleanup();
        }
        if (object == null) {
            if (!this.containsNull) {
                this.containsNull = true;
                ++this.modCount;
                ++this.size;
                return true;
            }
            return false;
        }
        int hashCode = this.hashCode(object);
        int index = WeakInterningHashSet.index(hashCode, this.entries.length);
        Entry<E> entry = this.entries[index];
        while (entry != null) {
            Object otherObject;
            if (hashCode == entry.hashCode && (object == (otherObject = entry.get()) || this.equals(object, otherObject))) {
                return false;
            }
            entry = entry.next;
        }
        this.addEntry(index, this.newEntry(object, hashCode));
        return true;
    }

    @Override
    public E intern(E object) {
        if (this.internalQueue != null) {
            this.cleanup();
        }
        if (object == null) {
            if (!this.containsNull) {
                this.containsNull = true;
                ++this.modCount;
                ++this.size;
            }
            return null;
        }
        int hashCode = this.hashCode(object);
        int index = WeakInterningHashSet.index(hashCode, this.entries.length);
        Entry<E> entry = this.entries[index];
        while (entry != null) {
            Object otherObject;
            if (hashCode == entry.hashCode && (object == (otherObject = entry.get()) || this.equals(object, otherObject))) {
                return (E)otherObject;
            }
            entry = entry.next;
        }
        this.addEntry(index, this.newEntry(object, hashCode));
        return object;
    }

    @Override
    public E get(E object) {
        if (this.internalQueue != null) {
            this.cleanup();
        }
        if (object == null) {
            return null;
        }
        int hashCode = this.hashCode(object);
        int index = WeakInterningHashSet.index(hashCode, this.entries.length);
        Entry<E> entry = this.entries[index];
        while (entry != null) {
            Object otherObject;
            if (hashCode == entry.hashCode && (object == (otherObject = entry.get()) || this.equals(object, otherObject))) {
                return (E)otherObject;
            }
            entry = entry.next;
        }
        return null;
    }

    @Override
    public boolean contains(Object object) {
        if (this.internalQueue != null) {
            this.cleanup();
        }
        if (object == null) {
            return this.containsNull;
        }
        E instance = this.asInstance(object);
        if (instance == null) {
            return false;
        }
        int hashCode = this.hashCode(instance);
        int index = WeakInterningHashSet.index(hashCode, this.entries.length);
        Entry<E> entry = this.entries[index];
        while (entry != null) {
            Object otherObject;
            if (hashCode == entry.hashCode && (instance == (otherObject = entry.get()) || this.equals(instance, otherObject))) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        if (this.internalQueue != null) {
            this.cleanup();
        }
        return new Iterator<E>(){
            int expectedModCount;
            int index;
            E nextObject;
            Entry<E> nextEntry;
            E removeObject;
            Entry<E> removeEntry;
            {
                this.expectedModCount = WeakInterningHashSet.this.modCount;
                if (WeakInterningHashSet.this.size > 0) {
                    if (WeakInterningHashSet.this.containsNull) {
                        this.index = -1;
                        this.nextEntry = WeakInterningHashSet.this.nullEntry();
                    } else {
                        do {
                            Object object;
                            Entry entry;
                            if ((entry = WeakInterningHashSet.this.entries[this.index]) == null || (object = entry.get()) == null) continue;
                            this.nextObject = object;
                            this.nextEntry = entry;
                            break;
                        } while (++this.index != WeakInterningHashSet.this.entries.length);
                    }
                }
            }

            @Override
            public boolean hasNext() {
                if (WeakInterningHashSet.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                return this.nextEntry != null;
            }

            @Override
            public E next() {
                if (this.nextEntry == null) {
                    throw new NoSuchElementException();
                }
                this.removeObject = this.nextObject;
                this.removeEntry = this.nextEntry;
                Object result = this.nextObject;
                Entry entry = this.nextEntry.next;
                while (true) {
                    if (entry != null) {
                        Object object = entry.get();
                        if (object != null) {
                            this.nextObject = object;
                            this.nextEntry = entry;
                            break;
                        }
                        entry = entry.next;
                        continue;
                    }
                    if (++this.index == WeakInterningHashSet.this.entries.length) {
                        this.nextEntry = null;
                        this.nextObject = null;
                        break;
                    }
                    entry = WeakInterningHashSet.this.entries[this.index];
                }
                return result;
            }

            @Override
            public void remove() {
                if (WeakInterningHashSet.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.removeEntry == null) {
                    throw new IllegalStateException();
                }
                if (WeakInterningHashSet.this.internalQueue != null) {
                    WeakInterningHashSet.this.removeEntry(this.removeEntry);
                    this.removeEntry.clear();
                } else {
                    this.removeEntry.clear();
                }
                this.expectedModCount = WeakInterningHashSet.this.modCount;
                this.removeObject = null;
                this.removeEntry = null;
            }
        };
    }

    protected static int index(int hashCode, int capacity) {
        return (hashCode & Integer.MAX_VALUE) % capacity;
    }

    protected Entry<E> getEntry(int hashCode) {
        if (this.internalQueue != null) {
            this.cleanup();
        }
        int index = WeakInterningHashSet.index(hashCode, this.entries.length);
        Entry<E> entry = this.entries[index];
        while (entry != null) {
            if (hashCode == entry.hashCode) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    protected Entry<E> nullEntry() {
        return NULL_ENTRY;
    }

    protected final Entry<E> newEntry(E object, int hashCode) {
        assert (this.hashCode(object) == hashCode);
        return this.internalQueue != null ? this.newInternalEntry(object, hashCode) : this.newExternalEntry(object, hashCode);
    }

    protected Entry<E> newInternalEntry(E object, int hashCode) {
        return new Entry<E>(object, hashCode, this.internalQueue);
    }

    protected Entry<E> newExternalEntry(E object, int hashCode) {
        return new SelfCleaningEntry<Object>(this, object, hashCode, this.externalQueue);
    }

    protected void putEntry(int index, Entry<E> entry) {
        Entry<E> otherEntry = this.entries[index];
        this.entries[index] = entry;
        entry.next = otherEntry;
    }

    protected void addEntry(int index, Entry<E> entry) {
        if (this.ensureCapacity()) {
            index = WeakInterningHashSet.index(entry.hashCode, this.entries.length);
        }
        ++this.size;
        ++this.modCount;
        this.putEntry(index, entry);
    }

    protected void removeEntry(Entry<E> entry) {
        if (this.removeEntry(WeakInterningHashSet.index(entry.hashCode, this.entries.length), entry)) {
            --this.size;
            ++this.modCount;
        }
    }

    protected boolean removeEntry(int index, Entry<E> entry) {
        Entry<E> otherEntry = this.entries[index];
        if (entry == otherEntry) {
            this.entries[index] = entry.next;
            return true;
        }
        if (otherEntry != null) {
            Entry nextOtherEntry = otherEntry.next;
            while (nextOtherEntry != null) {
                if (nextOtherEntry == entry) {
                    otherEntry.next = entry.next;
                    return true;
                }
                otherEntry = nextOtherEntry;
                nextOtherEntry = nextOtherEntry.next;
            }
        }
        return false;
    }

    public void dump() {
        int[] collisions = new int[this.size + 1];
        int maxCollisions = 0;
        System.out.println("size = " + this.size);
        System.out.println("null = " + this.containsNull);
        int i = 0;
        while (i < this.entries.length) {
            System.out.print(i);
            System.out.print(": ");
            int count = 0;
            Entry<E> entry = this.entries[i];
            while (entry != null) {
                System.out.print("(" + entry.hashCode + ", " + entry.get() + ")");
                if (entry.next != null) {
                    System.out.print(" -> ");
                }
                entry = entry.next;
                ++count;
            }
            int n = count;
            collisions[n] = collisions[n] + 1;
            if (count > maxCollisions) {
                maxCollisions = count;
            }
            System.out.println();
            ++i;
        }
        System.out.print("Collisions % {");
        DecimalFormat percentInstance = new DecimalFormat("##0.0000");
        int i2 = 0;
        while (i2 <= maxCollisions) {
            if (i2 != 0) {
                System.out.print(", ");
            }
            System.out.print(percentInstance.format(100.0 * (double)collisions[i2] / (double)this.entries.length));
            System.out.print("% ");
            ++i2;
        }
        System.out.println("}");
        System.out.print("Utilization % {");
        i2 = 1;
        while (i2 <= maxCollisions) {
            if (i2 != 1) {
                System.out.print(", ");
            }
            System.out.print(percentInstance.format(100.0 * (double)i2 * (double)collisions[i2] / (double)this.size));
            System.out.print("% ");
            ++i2;
        }
        System.out.println("}");
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeByte(this.capacityIndex);
        if (this.size > 0) {
            for (E object : this) {
                objectOutputStream.writeObject(object);
            }
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.internalQueue = new ReferenceQueue();
        this.capacityIndex = objectInputStream.readByte();
        int capacity = PRIME_CAPACITIES[this.capacityIndex];
        this.entries = this.newEntries(capacity);
        this.threshold = capacity * 3 / 4;
        if (this.size > 0) {
            int i = 0;
            while (i < this.size) {
                Object object = objectInputStream.readObject();
                if (object == null) {
                    this.containsNull = true;
                } else {
                    int hashCode = this.hashCode(object);
                    this.putEntry(WeakInterningHashSet.index(hashCode, capacity), this.newEntry(object, hashCode));
                }
                ++i;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Entry<E>
    extends WeakReference<E> {
        public final int hashCode;
        public Entry<E> next;

        private Entry() {
            super(null);
            this.hashCode = 0;
        }

        public Entry(E object, int hashCode, ReferenceQueue<? super E> queue) {
            super(object, queue);
            this.hashCode = hashCode;
        }

        public final Entry<E> getNextEntry() {
            Entry<E> entry = this.next;
            while (entry != null) {
                if (entry.hashCode == this.hashCode) {
                    return entry;
                }
                entry = entry.next;
            }
            return null;
        }

        @Override
        public void clear() {
            this.doClear();
        }

        protected void doClear() {
            this.next = null;
            super.clear();
        }

        public final void clear(WeakInterningHashSet<E> set) {
            set.removeEntry(this);
            this.doClear();
        }

        public String toString() {
            Object object = this.get();
            return object == null ? "null" : object.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SelfCleaningEntry<E>
    extends Entry<E> {
        protected final WeakInterningHashSet<E> set;

        public SelfCleaningEntry(WeakInterningHashSet<E> set, E object, int hashCode, ReferenceQueue<? super E> queue) {
            super(object, hashCode, queue);
            this.set = set;
        }

        @Override
        public void clear() {
            this.clear(this.set);
        }
    }
}

