/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.exception;

import com.ibm.db2.cmx.runtime.Data;
import com.ibm.db2.cmx.runtime.exception.DataRuntimeException;
import com.ibm.db2.cmx.runtime.exception.DataSQLException;
import com.ibm.db2.cmx.runtime.exception.GenerationException;
import com.ibm.db2.cmx.runtime.exception.LicenseException;
import com.ibm.db2.cmx.runtime.exception.UpdateManyException;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.cmx.tools.internal.generator.metadata.MethodInfo;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.core.dom.ASTNode;

public class ExceptionFactory {
    private static final String thisClassName = ExceptionFactory.class.getName();

    public static DataRuntimeException createDataRuntimeExceptionForRuntimeOnly(Data data, String string, Throwable throwable, int n2) {
        DataRuntimeException dataRuntimeException = new DataRuntimeException(string, throwable, n2, "3.3306.7");
        ExceptionFactory.correctStackTrace(dataRuntimeException);
        ExceptionFactory.logException(data, (Throwable)dataRuntimeException);
        if (Log.isLoggable(throwable)) {
            Log.dumpRingBuffer(throwable);
        }
        return dataRuntimeException;
    }

    public static LicenseException createLicenseExceptionForRuntimeOrTools(String string, Throwable throwable, int n2) {
        LicenseException licenseException = new LicenseException(string, throwable, n2, "3.3306.7");
        ExceptionFactory.correctStackTrace(licenseException);
        ExceptionFactory.logException((Data)null, (Throwable)licenseException);
        return licenseException;
    }

    public static DataRuntimeException createDataRuntimeExceptionForToolsOnly(String string, Throwable throwable, int n2) {
        DataRuntimeException dataRuntimeException = new DataRuntimeException(string, throwable, n2, "3.3306.7");
        ExceptionFactory.correctStackTrace(dataRuntimeException);
        ExceptionFactory.logException((Data)null, (Throwable)dataRuntimeException);
        return dataRuntimeException;
    }

    public static DataRuntimeException createDataRuntimeExceptionForToolsNoLog(String string, Throwable throwable, int n2) {
        DataRuntimeException dataRuntimeException = new DataRuntimeException(string, throwable, n2, "3.3306.7");
        return dataRuntimeException;
    }

    public static DataRuntimeException createDataRuntimeExceptionForRuntimeOnlyNoLogging(String string, Throwable throwable, int n2) {
        DataRuntimeException dataRuntimeException = new DataRuntimeException(string, throwable, n2, "3.3306.7");
        ExceptionFactory.correctStackTrace(dataRuntimeException);
        return dataRuntimeException;
    }

    public static DataRuntimeException createDataRuntimeExceptionForToolsOnlyNoLogging(String string, Throwable throwable, int n2) {
        DataRuntimeException dataRuntimeException = new DataRuntimeException(string, throwable, n2, "3.3306.7");
        ExceptionFactory.correctStackTrace(dataRuntimeException);
        return dataRuntimeException;
    }

    public static UpdateManyException createUpdateManyExceptionForRuntimeOnly(Data data, String string, Throwable throwable, int n2, int[] nArray, int[][] nArray2) {
        UpdateManyException updateManyException = new UpdateManyException(string, throwable, n2, "3.3306.7", nArray, nArray2);
        ExceptionFactory.correctStackTrace(updateManyException);
        ExceptionFactory.logException(data, (Throwable)updateManyException);
        return updateManyException;
    }

    public static GenerationException createGenerationExceptionForToolsOnly(String string, Throwable throwable, int n2, ASTNode aSTNode, MethodInfo methodInfo) {
        GenerationException generationException = new GenerationException(string, throwable, n2, "3.3306.7", aSTNode, methodInfo);
        ExceptionFactory.correctStackTrace(generationException);
        ExceptionFactory.logException((Data)null, (Throwable)generationException);
        return generationException;
    }

    public static DataSQLException createDataSQLExceptionForRuntimeOnly(String string, Throwable throwable, int n2) {
        DataSQLException dataSQLException = new DataSQLException(string, throwable, n2);
        ExceptionFactory.correctStackTrace(dataSQLException);
        return dataSQLException;
    }

    private static void correctStackTrace(Throwable throwable) {
        int n2;
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (n2 = 0; n2 < stackTraceElementArray.length && thisClassName.equals(stackTraceElementArray[n2].getClassName()); ++n2) {
        }
        StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[stackTraceElementArray.length - n2];
        System.arraycopy(stackTraceElementArray, n2, stackTraceElementArray2, 0, stackTraceElementArray2.length);
        throwable.setStackTrace(stackTraceElementArray2);
    }

    public static void logException(Data data, Throwable throwable) {
        Logger logger = null;
        if (null != data) {
            logger = data.getLogger();
        }
        if (null == logger) {
            logger = Log.getLogger();
        }
        if (null != logger) {
            ExceptionFactory.logException(logger, throwable);
        }
    }

    public static void logException(Logger logger, Throwable throwable) {
        throwable.getMessage();
        Level level = Level.FINE;
        if (null != logger && logger.isLoggable(level)) {
            String string = "";
            String string2 = "";
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            StackTraceElement stackTraceElement = stackTraceElementArray[0];
            if (null != stackTraceElementArray && null != stackTraceElement) {
                string = stackTraceElement.getClassName();
                string2 = stackTraceElement.getMethodName();
            }
            logger.logp(level, string, string2, "THROW", throwable);
        }
    }

    public static SQLException createDataSQLExceptionForOptimizer(Object object, String string, String string2, Throwable throwable, int n2) {
        return ExceptionFactory.createDataSQLExceptionForOptimizer(object, string, string2, -99999, throwable, n2);
    }

    public static SQLException createDataSQLExceptionForOptimizer(Object object, String string, String string2, int n2, Throwable throwable, int n3) {
        SQLException sQLException = null;
        if (throwable != null && throwable instanceof SQLException) {
            sQLException = (SQLException)throwable;
        } else {
            sQLException = new DataSQLException(string, string2, n2, throwable, n3);
            ExceptionFactory.correctStackTrace(sQLException);
        }
        ExceptionFactory.logException((Data)null, (Throwable)sQLException);
        return sQLException;
    }
}

