/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess;

import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.logging.LogRecord;

public class LogEntry {
    public int log_key;
    public String groupName;
    public String groupVersion;
    public String hostIp;
    public Timestamp logTime;
    public String message;
    public String logLevel;
    public int loggerId;
    public String details;

    public LogEntry(LogRecord logRecord, String string, String string2, String string3) {
        this.groupName = string;
        this.groupVersion = string2;
        this.hostIp = string3;
        this.logTime = new Timestamp(logRecord.getMillis());
        this.message = logRecord.getMessage();
        this.logLevel = logRecord.getLevel().getName();
        this.loggerId = Log.getRandomJVMID(string3);
        Throwable throwable = logRecord.getThrown();
        if (throwable != null) {
            this.details = LogEntry.getStackTrace(throwable);
        }
    }

    private static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        do {
            throwable.printStackTrace(printWriter);
        } while ((throwable = throwable.getCause()) != null);
        return stringWriter.toString();
    }

    public String toString() {
        return this.groupName + ";" + this.groupVersion + ";" + this.hostIp + ";" + this.logTime + ";" + this.message + ";" + this.logLevel + ";" + this.loggerId + ";" + this.details;
    }
}

