/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.polyglot.PauseThreadLocalAction;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class ContextPauseHandle
implements Future<Void> {
    final PauseThreadLocalAction pauseThreadLocalAction;
    private final Future<Void> pauseActionFuture;
    private boolean cancelled;

    ContextPauseHandle(PauseThreadLocalAction pauseThreadLocalAction, Future<Void> pauseActionFuture) {
        this.pauseThreadLocalAction = pauseThreadLocalAction;
        this.pauseActionFuture = pauseActionFuture;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.pauseActionFuture.cancel(mayInterruptIfRunning);
        this.resume();
        this.cancelled = true;
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled || this.pauseActionFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.cancelled || this.pauseActionFuture.isCancelled() || this.pauseThreadLocalAction.wasPaused(this.pauseActionFuture);
    }

    @Override
    public Void get() throws InterruptedException {
        this.pauseThreadLocalAction.waitUntilPaused(this.pauseActionFuture);
        if (this.cancelled || this.pauseActionFuture.isCancelled()) {
            throw new CancellationException();
        }
        return null;
    }

    @Override
    public Void get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        this.pauseThreadLocalAction.waitUntilPaused(this.pauseActionFuture, timeout, unit);
        if (this.cancelled || this.pauseActionFuture.isCancelled()) {
            throw new CancellationException();
        }
        return null;
    }

    void resume() {
        this.pauseThreadLocalAction.resume();
    }
}

