/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.api;

import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.GenerateLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.builtins.JSPromise;
import com.oracle.truffle.js.runtime.builtins.JSPromiseObject;

@GenerateLibrary
public abstract class PromiseLibrary
extends Library {
    private static final LibraryFactory<PromiseLibrary> FACTORY = LibraryFactory.resolve(PromiseLibrary.class);

    public static LibraryFactory<PromiseLibrary> getFactory() {
        return FACTORY;
    }

    public static PromiseLibrary getUncached() {
        return (PromiseLibrary)FACTORY.getUncached();
    }

    public boolean isPromise(Object object) {
        return object instanceof JSPromiseObject;
    }

    public State getState(Object promise) throws UnsupportedMessageException {
        if (promise instanceof JSPromiseObject) {
            JSPromiseObject jsPromise = (JSPromiseObject)((Object)promise);
            int state = JSPromise.getPromiseState(jsPromise);
            return switch (state) {
                case 0 -> State.PENDING;
                case 1 -> State.FULFILLED;
                case 2 -> State.REJECTED;
                default -> throw Errors.shouldNotReachHereUnexpectedValue(state);
            };
        }
        throw UnsupportedMessageException.create();
    }

    public void markHandled(Object promise) throws UnsupportedMessageException {
        if (!(promise instanceof JSPromiseObject)) {
            throw UnsupportedMessageException.create();
        }
        JSPromiseObject jsPromise = (JSPromiseObject)((Object)promise);
        jsPromise.setIsHandled(true);
    }

    public static enum State {
        PENDING,
        FULFILLED,
        REJECTED;

    }
}

