/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

public class IfmxTableDescriptor {
    private final String databaseName;
    private final String namespace;
    private final String tableName;

    public static IfmxTableDescriptor parse(String descriptor) {
        String[] lines = descriptor.split(":|\\.");
        if (lines.length != 3) {
            throw new IllegalArgumentException("Improper Informix table descriptor. It must be in the form <database name>:<namespace>.tableName");
        }
        return new IfmxTableDescriptor(lines[0], lines[1], lines[2]);
    }

    public IfmxTableDescriptor(String databaseName, String namespace, String tableName) {
        this.databaseName = databaseName;
        this.namespace = namespace;
        this.tableName = tableName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDesciptorString() {
        return this.databaseName + ":" + this.namespace + "." + this.tableName;
    }

    public String toString() {
        return this.getDesciptorString();
    }
}

