/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode.instrumentation;

import com.oracle.graal.python.nodes.bytecode.instrumentation.InstrumentedBytecodeStatement;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.debug.DebuggerTags;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;

class InstrumentedBytecodeStatementImpl
extends InstrumentedBytecodeStatement {
    @CompilerDirectives.CompilationFinal
    private boolean containsBreakpoint;
    @CompilerDirectives.CompilationFinal
    private int minBci = Integer.MAX_VALUE;
    @CompilerDirectives.CompilationFinal
    private int maxBci = Integer.MIN_VALUE;
    @Node.Children
    Node[] children;

    InstrumentedBytecodeStatementImpl() {
    }

    public boolean hasTag(Class<? extends Tag> tag) {
        return tag == StandardTags.StatementTag.class || tag == DebuggerTags.AlwaysHalt.class && this.containsBreakpoint;
    }

    @Override
    public void setContainsBreakpoint() {
        this.containsBreakpoint = true;
    }

    @Override
    public void insertHelperNode(Node node, int bci) {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.minBci != Integer.MAX_VALUE && this.maxBci != Integer.MIN_VALUE);
        if (this.children == null) {
            this.children = new Node[this.maxBci - this.minBci + 1];
        }
        this.children[bci - this.minBci] = this.insert(node);
    }

    @Override
    void coversBci(int bci, int length) {
        this.minBci = Math.min(this.minBci, bci);
        this.maxBci = Math.max(this.maxBci, bci + length);
    }
}

