/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jdbc.field.AbstractWithoutTimeZoneField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

final class FBDateField
extends AbstractWithoutTimeZoneField {
    FBDateField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
    }

    @Override
    public Object getObject() throws SQLException {
        return this.getDate();
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new Timestamp(this.getDatatypeCoder().decodeDateCalendar(this.getFieldData(), cal).getTime());
    }

    @Override
    public Date getDate(Calendar cal) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getDatatypeCoder().decodeDateCalendar(this.getFieldData(), cal);
    }

    @Override
    LocalDate getLocalDate() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getDatatypeCoder().decodeLocalDate(this.getFieldData());
    }

    @Override
    LocalDateTime getLocalDateTime() throws SQLException {
        LocalDate localDate = this.getLocalDate();
        return localDate != null ? localDate.atStartOfDay() : null;
    }

    @Override
    public String getString() throws SQLException {
        LocalDate localDate = this.getLocalDate();
        return localDate != null ? localDate.toString() : null;
    }

    @Override
    public void setString(String value) throws SQLException {
        this.setDate(this.fromString(value, Date::valueOf));
    }

    @Override
    public void setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        this.setFieldData(this.getDatatypeCoder().encodeDateCalendar(new Date(value.getTime()), cal));
    }

    @Override
    void setLocalDateTime(LocalDateTime value) throws SQLException {
        this.setLocalDate(value != null ? value.toLocalDate() : null);
    }

    @Override
    public void setDate(Date value, Calendar cal) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        this.setFieldData(this.getDatatypeCoder().encodeDateCalendar(value, cal));
    }

    @Override
    void setLocalDate(LocalDate value) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        this.setFieldData(this.getDatatypeCoder().encodeLocalDate(value));
    }

    @Override
    public DatatypeCoder.RawDateTimeStruct getRawDateTimeStruct() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getDatatypeCoder().decodeDateRaw(this.getFieldData());
    }

    @Override
    public void setRawDateTimeStruct(DatatypeCoder.RawDateTimeStruct raw) throws SQLException {
        if (this.setWhenNull(raw)) {
            return;
        }
        this.setFieldData(this.getDatatypeCoder().encodeDateRaw(raw));
    }
}

