/**
 * ./src/classes/keyboards.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import { IXkbLayout, IXkbModel, IXkbOption, IXkbVariant } from '../interfaces/i-xkb-model.js';
/**
 * /usr/share/X11/xkb/rules/xorg.lst
 */
export default class Keyboard {
    layouts: string[];
    models: string[];
    options: string[];
    variants: string[];
    constructor();
    /**
     * XKBLAYOUT='us'
     */
    getLayout(): Promise<string>;
    /**
     * XKBLAYOUT=[]
     */
    getLayouts(): IXkbLayout[];
    /**
     * XKBMODEL='pc105'
     */
    getModel(): Promise<string>;
    /**
     * XKBMODEL[]
     */
    getModels(): IXkbModel[];
    /**
     * XKBOPTIONS=''
     */
    getOption(): Promise<string>;
    /**
     * XKBOPTIONS[]
     */
    getOptions(): IXkbOption[];
    /**
     * XKBVARIANT=''
     */
    getVariant(): Promise<string>;
    /**
     * IXkbVariant[]
     */
    getVariants(layout: string): IXkbVariant[];
}
