/*
 * Decompiled with CFR 0.152.
 */
package com.lizardworks.tiff;

import com.lizardworks.tiff.IFD;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;

class CodedImage {
    public byte[] imageBytes;
    public byte[][] imageStrips;
    public long compType;
    public int bitsPerSample;
    public int samplesPerPixel;
    public int extraSamples;
    public int photometric;
    public int imageWidth;
    public int imageHeight;
    IFD ifd;

    public CodedImage(IFD ifd) {
        this.ifd = ifd;
        this.imageBytes = null;
        this.imageStrips = null;
        this.compType = 1L;
        this.imageWidth = 0;
        this.imageHeight = 0;
        this.bitsPerSample = 0;
        this.samplesPerPixel = 1;
        this.extraSamples = -1;
        this.photometric = 0;
        int i = 0;
        while (i < ifd.count) {
            if (ifd.entries[i].tag.equals(256)) {
                this.imageWidth = (int)ifd.entries[i].value;
            } else if (ifd.entries[i].tag.equals(257)) {
                this.imageHeight = (int)ifd.entries[i].value;
            } else if (ifd.entries[i].tag.equals(259)) {
                this.compType = ifd.entries[i].value;
            } else if (ifd.entries[i].tag.equals(258)) {
                this.bitsPerSample = ifd.entries[i].isOffset() ? (ifd.entries[i].type.isShort() ? ((ifd.entries[i].dataArray[0] & 0xFF) << 8) + (ifd.entries[i].dataArray[1] & 0xFF) : ((ifd.entries[i].dataArray[0] & 0xFF) << 24) + ((ifd.entries[i].dataArray[1] & 0xFF) << 16) + ((ifd.entries[i].dataArray[2] & 0xFF) << 8) + (ifd.entries[i].dataArray[3] & 0xFF)) : (int)ifd.entries[i].value;
            } else if (ifd.entries[i].tag.equals(277)) {
                this.samplesPerPixel = (int)ifd.entries[i].value;
            } else if (ifd.entries[i].tag.equals(338)) {
                this.extraSamples = (int)ifd.entries[i].value;
            } else if (ifd.entries[i].tag.equals(262)) {
                this.photometric = (int)ifd.entries[i].value;
            }
            ++i;
        }
    }

    boolean isRaw() {
        return this.compType == 1L;
    }

    boolean isJPEG() {
        return this.compType == 7L || this.compType == 6L;
    }

    boolean isCCITT() {
        return this.compType == 3L || this.compType == 4L || this.compType == 2L || this.compType == 32771L;
    }

    ColorModel makeColorModel() {
        byte[] rLUT = new byte[256];
        byte[] gLUT = new byte[256];
        byte[] bLUT = new byte[256];
        int i = 0;
        while (i < 256) {
            rLUT[i] = (byte)(i & 0xFF);
            gLUT[i] = (byte)(i & 0xFF);
            bLUT[i] = (byte)(i & 0xFF);
            ++i;
        }
        return new IndexColorModel(8, 256, rLUT, gLUT, bLUT);
    }

    ColorModel makeRGBColorModel() {
        int j;
        int i;
        int b;
        int g;
        int r;
        byte[] map = this.ifd.GetEntry((int)320).dataArray;
        int n = map.length / 6;
        byte[] rLUT = new byte[256];
        byte[] gLUT = new byte[256];
        byte[] bLUT = new byte[256];
        if (this.ifd.GetEntry((int)262).value == 3L) {
            r = 0;
            g = n * 2;
            b = n * 4;
            System.out.println("----------------- PALETTE ------------------");
            i = 0;
            j = 0;
            while (i < n) {
                rLUT[i] = (byte)(map[j + r] & 0xFF);
                gLUT[i] = (byte)(map[j + g] & 0xFF);
                bLUT[i] = (byte)(map[j + b] & 0xFF);
                System.out.println("#" + i + " = (" + (rLUT[i] & 0xFF) + "," + (gLUT[i] & 0xFF) + "," + (bLUT[i] & 0xFF) + "), ");
                ++i;
                j += 2;
            }
        } else {
            r = 0;
            g = 2;
            b = 4;
            System.out.println("----------------- PALETTE ------------------");
            i = 0;
            j = 0;
            while (i < n) {
                rLUT[i] = (byte)(map[j + r] & 0xFF);
                gLUT[i] = (byte)(map[j + g] & 0xFF);
                bLUT[i] = (byte)(map[j + b] & 0xFF);
                System.out.println("#" + i + " = (" + (rLUT[i] & 0xFF) + "," + (gLUT[i] & 0xFF) + "," + (bLUT[i] & 0xFF) + "), ");
                ++i;
                j += 6;
            }
        }
        i = n;
        while (i < 256) {
            rLUT[i] = 0;
            gLUT[i] = 0;
            bLUT[i] = 0;
            ++i;
        }
        return new IndexColorModel(this.bitsPerSample, n, rLUT, gLUT, bLUT);
    }

    int GetR(int abgr) {
        return abgr & 0xFF;
    }

    int GetG(int abgr) {
        return abgr >> 8 & 0xFF;
    }

    int GetB(int abgr) {
        return abgr >> 16 & 0xFF;
    }

    int GetA(int abgr) {
        return abgr >> 24 & 0xFF;
    }

    public Image getImage() {
        Image img = null;
        ImageProducer ip = (ImageProducer)this.getImageProducer();
        if (ip != null) {
            img = Toolkit.getDefaultToolkit().createImage(ip);
        }
        return img;
    }

    public Object getImageProducer() {
        ColorModel cm = this.makeColorModel();
        this.imageWidth = 256;
        this.imageHeight = 256;
        int[] pixels = new int[this.imageWidth * this.imageHeight];
        int y = 0;
        while (y < pixels.length) {
            int x = 0;
            while (x < this.imageWidth) {
                pixels[x + y] = x & 0xFF;
                ++x;
            }
            y += this.imageWidth;
        }
        return new MemoryImageSource(this.imageWidth, this.imageHeight, pixels, 0, this.imageWidth);
    }

    boolean CanDecodeImage() {
        switch (this.bitsPerSample) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                break;
            }
            default: {
                String emsg = "Sorry, can not handle images with " + this.bitsPerSample + "-bit samples";
                System.out.println(emsg);
                return false;
            }
        }
        int colorChannels = this.extraSamples == -1 ? this.samplesPerPixel : this.samplesPerPixel - this.extraSamples;
        if (this.photometric == 0 && this.extraSamples != -1) {
            switch (colorChannels) {
                case 1: {
                    this.photometric = 1;
                    break;
                }
                case 3: {
                    this.photometric = 2;
                    break;
                }
                default: {
                    String emsg = "Missing needed PHOTOMETRIC tag";
                    System.out.println(emsg);
                    return false;
                }
            }
        }
        switch (this.photometric) {
            case 0: 
            case 1: 
            case 3: {
                int planarConfig = this.ifd.GetFieldValue(284);
                if (planarConfig != 1 || this.samplesPerPixel == 1) break;
                String emsg = "Sorry, can not handle contiguous data with PHOTOMETRIC=" + this.photometric + ", and Samples per Pixel=" + this.samplesPerPixel;
                System.out.println(emsg);
                return false;
            }
            case 6: {
                int planarConfig = this.ifd.GetFieldValue(284);
                if (planarConfig == 1) break;
                String emsg = "Sorry, can not handle YCbCr images with Planarconfiguration=" + planarConfig;
                System.out.println(emsg);
                return false;
            }
            case 2: {
                if (colorChannels >= 3) break;
                String emsg = "Sorry, can not handle RGB image with Color channels=" + colorChannels;
                System.out.println(emsg);
                return false;
            }
            default: {
                String emsg = "Sorry, can not handle image with Photometric=" + this.photometric;
                System.out.println(emsg);
                return false;
            }
        }
        return true;
    }
}

