/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.history;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MVUsedUrl {
    private static final Logger logger = LogManager.getLogger(MVUsedUrl.class);
    private static final String TRENNER = "  |###|  ";
    private static final String PAUSE = " |#| ";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private final LocalDate datum;
    private final String thema;
    private final String titel;
    private final String url;

    public MVUsedUrl(String date, String thema, String title, String url) {
        LocalDate tempDate;
        try {
            tempDate = LocalDate.parse(date, DATE_TIME_FORMATTER);
        }
        catch (DateTimeException ex) {
            logger.error("Failed to parse date: \"{}\" for thema: \"{}\", titel: \"{}\" and URL: \"{}\"", (Object)date, (Object)thema, (Object)title, (Object)url);
            logger.error("Resetting date to current date...");
            tempDate = LocalDate.now();
        }
        this.datum = tempDate;
        this.thema = thema;
        this.titel = title;
        this.url = url;
    }

    public MVUsedUrl(String thema, String title, String url) {
        this.datum = LocalDate.now();
        this.thema = thema;
        this.titel = title;
        this.url = url;
    }

    public static MVUsedUrl getUrlAusZeile(String zeile) {
        String url = "";
        String thema = "";
        String titel = "";
        String datum = "";
        try {
            if (zeile.contains(TRENNER)) {
                int a1 = zeile.lastIndexOf(TRENNER);
                url = zeile.substring(a1 += TRENNER.length()).trim();
                titel = zeile.substring(zeile.lastIndexOf(PAUSE) + PAUSE.length(), zeile.lastIndexOf(TRENNER)).trim();
                datum = zeile.substring(0, zeile.indexOf(PAUSE)).trim();
                thema = zeile.substring(zeile.indexOf(PAUSE) + PAUSE.length(), zeile.lastIndexOf(PAUSE)).trim();
            } else {
                url = zeile;
            }
        }
        catch (Exception ex) {
            logger.error("getUrlAusZeile", (Throwable)ex);
        }
        return new MVUsedUrl(datum, thema, titel, url);
    }

    private String putzen(String s2) {
        s2 = StringUtils.replace(s2, "\n", "");
        s2 = StringUtils.replace(s2, "|", "");
        s2 = StringUtils.replace(s2, TRENNER, "");
        return s2;
    }

    public String getDatum() {
        return DATE_TIME_FORMATTER.format(this.datum);
    }

    public String getThema() {
        return this.thema;
    }

    public String getTitel() {
        return this.titel;
    }

    public String getPreparedRowString() {
        return String.format("%s%s%s%s%s%s%s%n", this.getDatum(), PAUSE, this.putzen(this.thema), PAUSE, this.putzen(this.titel), TRENNER, this.url);
    }

    public String getUrl() {
        return this.url;
    }
}

